<?php

namespace Drupal\ai_seo_link_advisor\Analyzer\Metric\Page;

use Drupal\ai_seo_link_advisor\Analyzer\Metric\AbstractMetric;

/**
 * Provides an AltsMetric class for SEO analysis.
 */
class KeywordDescriptionMetric extends AbstractMetric {

  /**
   * Analyzes page.
   */
  public function analyze(): string {
    $this->description = $this->t('Does the meta description contain the keyword?');

    if (!is_array($this->value) && $this->value == FALSE) {
      $this->value = [];
    }

    if (isset($this->value['type'])) {
      $this->name = 'Keyword' . $this->value['type'];
    }

    // Check if there is a meta-description.
    if (empty($this->value['text'])) {
      $this->impact = 10;
      $this->value['text'] = $this->t('MISSING!');
      return $this->t('You do not have a meta description on your page. You should add this because it is really important for your SEO');
    }

    // Ensure that $this->value['keyword'] is set, is a string, and not false.
    if (empty($this->value['keyword']) || is_bool($this->value['keyword'])) {
      $this->value['keyword'] = '';
    }

    // Check if the description contains the keyword.
    if (!empty($this->value['keyword']) && stripos($this->value['text'], $this->value['keyword']) === FALSE) {
      $this->impact = $this->value['impact'];
      return $this->t('Cannot find the keyword in the meta description tag. Adding it could improve SEO');
    }

    return $this->t('Good! Found the keyword in the meta description tag');
  }

}
