<?php

namespace Drupal\ai_seo_link_advisor\Analyzer\Metric\Page;

use Drupal\ai_seo_link_advisor\Analyzer\Metric\AbstractMetric;

/**
 * Provides a KeywordMetric class for SEO analysis.
 */
class KeywordMetric extends AbstractMetric {

  /**
   * Analyzes page.
   */
  public function analyze(): string {
    $this->description = $this->t('OLD Does the meta description contain the keyword?');
    $this->name = 'Keyword' . $this->value['type'];

    if (stripos($this->value['text'], $this->value['keyword']) === FALSE) {
      $this->impact = $this->value['impact'];
      return $this->t('Can not find the keyword in the meta description tag. Adding it could improve SEO');
    }

    return $this->t('Good! Found the keyword in the meta description tag');
  }

}
