<?php

namespace Drupal\ai_seo_link_advisor\Analyzer\Metric\Page;

use Drupal\ai_seo_link_advisor\Analyzer\Metric\AbstractMetric;

/**
 * Provides a RedirectMetric class for SEO analysis.
 */
class RedirectMetric extends AbstractMetric {

  /**
   * Analyzes page.
   */
  public function analyze(): string {
    $this->description = $this->t('Does the page redirect to another url?');

    if ($this->value['redirect']) {
      $this->impact = 2;
      return $this->t('You should avoid redirects, as this could have impact on SEO');
    }

    return $this->t('No');
  }

}
