<?php

namespace Drupal\ai_seo_link_advisor\Analyzer\Parser;

/**
 * Provides a ParserInterface class for SEO analysis.
 */
interface ParserInterface {

  /**
   * Sets the HTML document content to be parsed.
   *
   * @param string $html
   *   The HTML document content.
   */
  public function setContent(string $html): void;

  /**
   * Returns the meta-headers content of the document.
   *
   * @return array
   *   An associative array of meta-headers.
   */
  public function getMeta(): array;

  /**
   * Returns the header content of the document.
   *
   * @param bool $keyword
   *   (Optional) Whether to include the keyword in the headers.
   *
   * @return array
   *   An associative array of headers.
   */
  public function getHeaders(bool $keyword = FALSE): array;

  /**
   * Returns the title content of the page.
   *
   * @return string
   *   The title of the page.
   */
  public function getTitle(): string;

  /**
   * Returns the alt attributes of img tags in the document.
   *
   * @return array
   *   An array of alt attributes.
   */
  public function getImages(): array;

  /**
   * Returns the plain text content without HTML tags.
   *
   * @return string
   *   The plain text content.
   */
  public function getText(): string;

}
