# OpenSearch Vector Database Provider

This module provides integration between Drupal's AI module and OpenSearch as a vector database (VDB) for storing and retrieving vector embeddings.

## Overview

OpenSearch is a distributed, open-source search and analytics suite derived from Elasticsearch. It offers vector search capabilities through its k-NN functionality, which makes it suitable for semantic search applications.

This module allows Drupal to use OpenSearch as a vector database for:
- Storing vector embeddings from content
- Performing similarity searches
- Creating and managing vector collections

## Requirements

- Drupal 10
- AI module
- OpenSearch 2.4+ with k-NN plugin installed and enabled
- Key module (for securely storing credentials)

## Installation

1. Install OpenSearch: Follow the [official documentation](https://opensearch.org/docs/latest/install-and-configure/) to install OpenSearch or use a managed service like AWS OpenSearch Service.

2. Enable the module:
   ```bash
   composer require drupal/ai_vdb_provider_opensearch
   drush en ai_vdb_provider_opensearch
   ```

## Configuration

1. Navigate to `/admin/config/search/ai/vdb-providers/opensearch`
2. Enter your OpenSearch connection details:
   - Server URL (e.g., http://opensearch or https://my-opensearch-domain.region.es.amazonaws.com)
   - Port (default: 9200)
   - Authentication credentials (if required)

3. Configure the AI module to use OpenSearch as your vector database.

## Usage with AWS OpenSearch Service

For AWS OpenSearch Service:
1. Enable `search_api_aws_signature_connector` module
2. Set the Server URL to your AWS OpenSearch domain endpoint
2. Set the Port to 443
3. For Authentication, create a Key using AWS Signature V4 format or IAM user credentials

## Local Development with DDEV

A DDEV configuration is available for local development:

1. Copy the OpenSearch service configuration to your DDEV config
2. Start DDEV with `ddev start`
3. Configure this module to use:
   - Server URL: http://opensearch
   - Port: 9200
   - No authentication for local development

## Vector Field Configuration

OpenSearch requires specific field mapping for vector search. This module automatically:
- Creates appropriate mappings for vector fields
- Configures the k-NN settings based on the similarity metric selected
- Handles the conversion between AI module's vector storage format and OpenSearch's requirements

## Troubleshooting

- Verify OpenSearch is running and accessible
- Check that the k-NN plugin is installed and enabled
- Review log files for connection issues
- For AWS OpenSearch Service, ensure your IAM permissions are correct

## Support

For issues and feature requests, please use the [issue queue](https://www.drupal.org/project/issues/ai_vdb_provider_opensearch).
