<?php

namespace Drupal\ai_webform_guard\Service;

use Drupal\ai\AiProviderPluginManager;
use Drupal\Core\Config\ConfigFactoryInterface;

/**
 * Helper class for AI provider.
 */
class ProviderHelper implements ProviderHelperInterface {

  /**
   * The configuration factory.
   *
   * @var \Drupal\Core\Config\ConfigFactoryInterface
   */
  protected $configFactory;

  /**
   * The AI provider manager.
   *
   * @var \Drupal\ai\AiProviderPluginManager
   */
  protected $aiProviderManager;

  /**
   * Constructs a new \Drupal\ai_webform_guard\Service\ProviderHelper object.
   *
   * @param \Drupal\Core\Config\ConfigFactoryInterface $configFactory
   *   The configuration factory.
   * @param \Drupal\ai\AiProviderPluginManager $aiProviderManager
   *   The AI provider manager.
   */
  public function __construct(ConfigFactoryInterface $configFactory, AiProviderPluginManager $aiProviderManager) {
    $this->configFactory = $configFactory;
    $this->aiProviderManager = $aiProviderManager;
  }

  /**
   * Get the set provider.
   *
   * @return array|null
   *   The set provider.
   */
  public function getSetProvider() {
    // Check if there is a preferred model.
    $preferred_model = $this->configFactory->get('ai_webform_guard.settings')->get('ai_model');
    if ($preferred_model) {
      return [
        'provider_id' => $this->aiProviderManager->loadProviderFromSimpleOption($preferred_model),
        'model_id' => $this->aiProviderManager->getModelNameFromSimpleOption($preferred_model),
      ];
    }

    $default_provider = $this->aiProviderManager->getDefaultProviderForOperationType('chat_with_complex_json');
    if (empty($default_provider['provider_id'])) {
      // If we got nothing return NULL.
      return NULL;
    }

    return [
      'provider_id' => $this->aiProviderManager->createInstance($default_provider['provider_id']),
      'model_id' => $default_provider['model_id'],
    ];
  }

}
