<?php

namespace Drupal\ai_webform_guard\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\webform\Entity\Webform;

/**
 * Defines a settings form for AI Webform Guard.
 */
class AIWebformGuardFieldsSettingsForm extends ConfigFormBase {

  /**
   * Config settings.
   */
  const CONFIG_NAME = 'ai_webform_guard.fields_settings';

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'ai_webform_guard_fields_settings';
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return [
      static::CONFIG_NAME,
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $config = $this->config(static::CONFIG_NAME);
    $settings_fields_config = $config->get('settings_fields') ?? [];

    $form['description'] = [
      '#markup' => '<h5>' . $this->t("Select which webform fields should be excluded from AI spam detection, and optionally set a custom prompt per webform.") . '</h5>',
    ];

    $form['settings_fields'] = [
      '#type' => 'fieldset',
      '#tree' => TRUE,
    ];

    $webforms = Webform::loadMultiple();

    foreach ($webforms as $webform_id => $webform) {
      $form['settings_fields'][$webform_id] = [
        '#type' => 'details',
        '#title' => $webform->label(),
        '#open' => FALSE,
      ];

      $elements = $webform->getElementsInitializedFlattenedAndHasValue();

      foreach ($elements as $key => $element) {
        $form['settings_fields'][$webform_id]['excluded_fields'][$key] = [
          '#type' => 'checkbox',
          '#title' => $element['#title'] ?? $key,
          '#default_value' => $settings_fields_config[$webform_id]['excluded_fields'][$key] ?? FALSE,
        ];
      }

      $form['settings_fields'][$webform_id]['custom_prompt'] = [
        '#type' => 'textarea',
        '#title' => $this->t('Custom prompt'),
        '#default_value' => $settings_fields_config[$webform_id]['custom_prompt'] ?? '',
        '#description' => $this->t('Custom prompt used for generating the spam detection.'),
      ];
    }

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $excluded_fields = $form_state->getValue('settings_fields') ?? [];

    $this->config(static::CONFIG_NAME)
      ->set('settings_fields', $excluded_fields)
      ->save();

    parent::submitForm($form, $form_state);
  }

}
