# AI Webform Guard

AI Webform Guard is a lightweight Drupal module that protects your [Webform](https://www.drupal.org/project/webform) submissions from spam using AI-powered classification.

Instead of using traditional CAPTCHA mechanisms, this module analyzes submissions in real time by sending a prompt to an LLM (e.g. OpenAI) and classifies the content as spam or not.

> This module integrates with the [AI module](https://www.drupal.org/project/ai) for Drupal.

---

## Features

-  Integrates with [Webform](https://www.drupal.org/project/webform)
-  Uses LLM-based AI detection to classify form submissions
-  **IP Address Whitelist**: Allow trusted IP addresses to bypass spam protection (supports wildcards)
-  **Flood Control**: Automatically blocks repeated spam attempts from the same IP to save AI resources
-  **Event System**: Dispatches events when spam is detected for custom integrations
-  Configurable AI model and prompt template (via admin UI)
-  Option to configure specific fields to be excluded from spam detection
-  Custom error messages for spam submissions
-  Logs blocked spam attempts (optional)
-  Human iteration support: Adds a checkbox for manual confirmation if submission is flagged as spam
-  Submission truncation: Limits the number of words sent to AI via max_words setting to reduce token usage

---

## Requirements

- [Webform](https://www.drupal.org/project/webform)
- [AI module](https://www.drupal.org/project/ai)
- A working AI provider (e.g. OpenAI, OpenRouter, etc.)

---

## Installation

1. Install via composer:
    ```bash
    composer require drupal/ai_webform_guard
    ```
2. Enable the module:
   ```bash
   drush en ai_webform_guard -y
   ```
3. Configure the AI provider and settings under **Administration > Configuration > AI Webform Guard settings**.

## Configuration

### AI Provider Settings
- **Webform guard generation prompt:** Define the AI prompt for spam analysis. Guide the AI to make meaningful classifications.
- **AI provider/model:** Choose the AI provider and model for spam detection.
- **Custom error message:** Specify a custom error message shown when spam is detected (optional).
- **Log spam attempts:** Enable logging of blocked spam submissions for monitoring.
- **Human Iteration:** Show a confirmation checkbox for users flagged as spam to verify they're legitimate.
- **Submission Truncation:** Limit words sent to AI to reduce token usage (default: 500 words ≈ 650-750 tokens).

### Allowed IP Addresses
Specify IP addresses that should bypass AI spam protection completely. Each IP address on a separate line.
- Supports wildcard characters (e.g., `192.0.2.*` or `10.0.*.*`)
- Useful for whitelisting administrator IPs, trusted networks, or testing environments
- Bypasses both flood control and AI checks for maximum efficiency

### Flood Control
Protects your forms and AI resources by blocking IPs that repeatedly trigger spam detection.
- **Enable Flood Control:** Activate automatic IP blocking after repeated spam attempts
- **Threshold:** Maximum number of spam attempts allowed (default: 5 attempts)
- **Window:** Time period in seconds for counting attempts (default: 60 seconds)

When the threshold is exceeded, further submissions from that IP are blocked immediately without calling the AI, saving costs and preventing abuse.

### Processing Order
For efficiency, submissions are checked in this order:
1. **IP Whitelist** - Whitelisted IPs bypass all checks
2. **Flood Control** - Blocked IPs are rejected without AI calls
3. **AI Detection** - Only if previous checks pass

### Field Exclusion Settings
- You can set the AI to ignore specific fields in the webform submission by configuring the excluded fields. This can be managed under **Administration > Configuration > AI Webform Guard Fields settings**.

### Spam Confirmation Flow (per Webform)

The **spam confirmation flow** feature allows you to integrate spam detection with email confirmation handlers, such as those provided by [Webform Email Confirmation Link](https://www.drupal.org/project/webform_email_confirmation_link).

#### How it works:
1. Navigate to **Administration > Configuration > AI Webform Guard > Field Settings**
2. For each webform, you can enable the **"Enable spam confirmation flow"** checkbox
3. When enabled, the module automatically manages the `email_confirmation` handler status based on spam detection:
   - **If spam is detected**: The `email_confirmation` handler is **enabled**, requiring email verification
   - **If no spam is detected**: The `email_confirmation` handler is **disabled**, allowing normal form processing

#### Setup:
1. Go to your webform settings
2. Navigate to the handlers section
3. Add an "Email confirmation" handler (provided by `webform_email_confirmation_link`)
4. Configure the handler as needed (email template, confirmation link settings, etc.)
5. You can leave the handler disabled by default - the module will enable it automatically when spam is detected
6. Enable the **"Enable spam confirmation flow"** checkbox in **AI Webform Guard Field Settings** for this webform

#### Behavior:
- **When NOT spam**: The email confirmation handler remains disabled, and the form submission proceeds normally through your other handlers (email notifications, database saves, etc.)
- **When spam is detected**: The email confirmation handler is automatically enabled, requiring the user to verify their submission via email link before it's fully processed

This dynamic approach ensures:
- Legitimate users have a smooth experience without extra verification steps
- Suspected spam submissions must go through email verification
- No manual handler conditions or hidden fields are needed

**Note:** This feature requires the `webform_email_confirmation_link` module to be installed. The checkbox will be disabled if the module is not available.

## Usage
1. Create your webform as usual.
2. Configure the settings according to your AI provider and preferences.
3. Test submissions to see the spam detection in action.
4. Flagged submissions will show a confirmation checkbox if human iteration is enabled, and AI will classify content based on field labels even for nested/grouped fields.
5. Long submissions will be truncated according to max_words to limit AI token usage.

## Benefits

### Cost Savings
- **IP Whitelist**: Trusted IPs bypass AI calls completely
- **Flood Control**: Repeat spammers are blocked without AI checks
- **Token Limits**: Configurable word limits reduce API costs

### Security & Performance
- **Multi-layer Protection**: IP whitelist → Flood control → AI detection
- **Automated Blocking**: IPs that repeatedly spam are automatically blocked
- **Resource Efficient**: Minimal processing for whitelisted and blocked IPs

### Flexibility
- **Event System**: Custom integrations via event subscribers
- **Per-form Configuration**: Different settings for different webforms
- **Wildcard Support**: Easily whitelist IP ranges and networks
