# AI Form Guard

A submodule of AI Webform Guard that extends spam detection to custom Drupal forms.

## Features

- Extends AI-based spam detection to custom forms
- Adds a field for custom form IDs directly in the existing AI Webform Guard settings form
- Uses the same AI models and settings as AI Webform Guard
- Seamless integration without separate configuration pages
- Per-form field exclusion configuration
- Custom AI prompts per form
- Centralized spam detection service

## Installation

1. Enable the `ai_form_guard` module
2. Navigate to "Configuration" > "AI" > "AI Webform Guard" > "AI Webform Guard settings"
3. In the new "Custom Form IDs" field, enter the form IDs of custom forms to protect (one per line)
4. Save the form

## Usage

### Configure Custom Form IDs

In the existing AI Webform Guard settings form at `/admin/config/ai/ai-webform-guard`, you'll find the new "Custom Form IDs" field:
- Enter one form ID per line
- Examples: `contact_form`, `user_register_form`, `custom_feedback_form`
- The entered forms will automatically be protected with AI spam detection

### Configure Form Field Settings

Navigate to **Configuration → AI → AI Webform Guard → AI Custom Form Fields** (`/admin/config/ai/ai-webform-guard/custom-form-fields`):

1. For each configured custom form, you can:
   - **Exclude fields**: Enter field names (one per line) that should NOT be included in spam analysis
   - **Custom prompt**: Set an individual AI prompt for better spam detection per form

2. Field names are validated at runtime when the form is submitted
3. Common fields to exclude: `form_build_id`, `form_token`, `form_id`, `op`

### Finding Form IDs

To find the correct form ID:

- **Devel module**: `drush devel:form [form_id]`
- **In code**: Look for `$form['#id']` or the form class
- **Browser DevTools**: Inspect the `<form id="...">` attribute
- **Routing files**: Check `.routing.yml` files for form definitions

**Common Drupal Form IDs:**
- `user_login_form` - User login
- `user_register_form` - User registration
- `user_pass` - Password reset
- `contact_message_form` - Contact form
- `comment_form` - Comment form

## Debugging

If spam detection is not working as expected:

1. Check the logs: `drush watchdog:show ai_form_guard`
2. Verify the form ID is correct and listed in the Custom Form IDs configuration
3. Ensure the AI provider is properly configured in AI Webform Guard settings
4. Check that excluded field names match the actual field names in the form

## Permissions

Configure under **People → Permissions**:
- **Administer AI Form Guard**: Permission to configure the module

## Dependencies

- AI Webform Guard
- AI module

## Technical Details

The module uses:
- **Hook classes** (`AiFormGuardFormHooks`) for modern Drupal best practices
- **Config forms** for settings and field configuration
- **Dependency injection** for services
- **Runtime field validation** for flexible field exclusion
- **Centralized spam detection service** (shared with AI Webform Guard)

## How It Works

1. **Form Alteration**: The module uses `hook_form_alter()` to attach validation handlers to configured custom forms
2. **Spam Detection**: Form submissions are analyzed using the centralized `SpamDetectionService` from AI Webform Guard
3. **Field Exclusion**: Configured fields are excluded from AI analysis
4. **AI Analysis**: Submission data is sent to the configured AI provider with a custom or default prompt
5. **Response Handling**: Based on AI classification, the submission is either blocked or allowed

## Architecture

- **Service Layer**: Uses `SpamDetectionService` from AI Webform Guard for shared spam detection logic
- **Hook Classes**: PHP 8 attributes-based hook implementations
- **Configuration Management**: YAML-based configuration with schema validation
- **Runtime Processing**: Field exclusion and validation happens during form submission

## Support

For issues or feature requests, please use the project's issue queue or contact your system administrator.


