<?php

declare(strict_types=1);

namespace Drupal\ai_webform_guard\Event;

use Drupal\Component\EventDispatcher\Event;

/**
 * Event that is fired when spam is detected.
 */
class SpamDetectedEvent extends Event {

  /**
   * The event name.
   */
  const EVENT_NAME = 'ai_webform_guard.spam_detected';

  /**
   * Constructs the object.
   *
   * @param string $formId
   *   The form ID.
   * @param array $formData
   *   The form data that was submitted.
   * @param string $responseText
   *   The AI response text.
   * @param string $clientIp
   *   The client IP address.
   */
  public function __construct(
    protected string $formId,
    protected array $formData,
    protected string $responseText,
    protected string $clientIp,
  ) {}

  /**
   * Gets the form ID.
   *
   * @return string
   *   The form ID.
   */
  public function getFormId(): string {
    return $this->formId;
  }

  /**
   * Gets the form data.
   *
   * @return array
   *   The form data.
   */
  public function getFormData(): array {
    return $this->formData;
  }

  /**
   * Gets the AI response text.
   *
   * @return string
   *   The response text.
   */
  public function getResponseText(): string {
    return $this->responseText;
  }

  /**
   * Gets the client IP address.
   *
   * @return string
   *   The client IP address.
   */
  public function getClientIp(): string {
    return $this->clientIp;
  }

}
