(function (Drupal) {

  'use strict';

  function intersectionObserver(placeholderElement) {
    const distance = placeholderElement.getAttribute('data-loading-distance') || '0';

    const observer = new IntersectionObserver((entries) => {
      entries.forEach((entry) => {
        if (entry.isIntersecting) {
          observer.unobserve(entry.target);
          ajaxBigPipeLoad(entry.target);
        }
      });
    }, {
      rootMargin: `${distance}px`
    });

    observer.observe(placeholderElement);
  }

  function ajaxBigPipeProcessDocument(context) {
    let elements = once('ajax-bigpipe', '[data-ajax-placeholder]', context);
    elements.forEach((item) => {
      if (!item.classList.contains('not-observer')) {
        intersectionObserver(item);
      }
      else {
        ajaxBigPipeLoad(item);
      }
    });
  }

  function ajaxBigPipeLoad(placeholderElement) {
    let submitData = JSON.parse(placeholderElement.dataset.ajaxPlaceholder);
    submitData.http_referrer = document.referrer || '';
    const ajax = new Drupal.ajax({
      url: drupalSettings.ajaxBigPipe,
      progress: false,
      submit: submitData
    })
    ajax.success = function (response, status) {
      // Call all provided AJAX commands.
      const postLoad = [];
      Object.keys(response || {}).forEach(function (i) {
        if (response[i].command && ajax.commands[response[i].command]) {
          if (!response[i].selector) {
            if (!response[i].selector) {
              // Set selector by our element.
              response[i].selector = placeholderElement;
            }
          }

          let notLoad = false;
          if (response[i].command && response[i].command === 'add_css') {
            if (typeof response[i].data !== 'string') {
              notLoad = true;
              postLoad.css = response[i];
            }
          }

          if (response[i].method && response[i].method === 'replaceWith') {
            notLoad = true;
            postLoad.html = response[i];
          }
          if(!notLoad) {
            ajax.commands[response[i].command](ajax, response[i], status);
          }
        }
      });

      if(postLoad.css) {
        const allUniqueBundleIds = postLoad.css.data.map(function (style) {
          return style.href + ajax.instanceIndex;
        });

        function waitForScripts(bundleId) {
          return ajax.commands[postLoad.css.command](ajax, postLoad.css, status);
        }

        waitForScripts(allUniqueBundleIds)
        .then(() => {
          if(postLoad.html) {
            ajax.commands[postLoad.html.command](ajax, postLoad.html, status);
            Drupal.attachBehaviors();
          }
        });
      }
      else if(postLoad.html) {
        ajax.commands[postLoad.html.command](ajax, postLoad.html, status);
      }
      Drupal.attachBehaviors();

      const event = new CustomEvent('ajaxBigPipeLoad', { detail: [] });
      document.body.dispatchEvent(event);
    };
    ajax.options.method = 'GET';
    ajax.options.type = 'GET';
    ajax.submit.destination = window.location.pathname;
    if(window.location.search) {
      ajax.submit.destination += window.location.search;
    }
    ajax.execute();
  }

  window.addEventListener('load', () => {
    ajaxBigPipeProcessDocument(document);
  });

})(Drupal);