<?php

namespace Drupal\ajax_cart_update\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Configuration form for AJAX Cart Update settings.
 */
class AjaxCartUpdateSettingsForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  public static function create($container): self {
    return new self(
      $container->get('config.factory'),
    );
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'ajax_cart_update_settings';
  }

  /**
   * {@inheritdoc}
   *
   * @return string[]
   *   An array of configuration object names that are editable.
   */
  protected function getEditableConfigNames(): array {
    return ['ajax_cart_update.settings'];
  }

  /**
   * {@inheritdoc}
   *
   * @param array<string, mixed> $form
   *   An associative array containing the structure of the form.
   * @param \Drupal\Core\Form\FormStateInterface $form_state
   *   The current state of the form.
   *
   * @return array<string, mixed>
   *   The form structure.
   */
  public function buildForm(array $form, FormStateInterface $form_state): array {
    $config = $this->config('ajax_cart_update.settings');

    $form['update_method'] = [
      '#type' => 'radios',
      '#title' => $this->t('Cart update method'),
      '#description' => $this->t('Choose how the cart totals and prices are updated.'),
      '#options' => [
        'selectors' => $this->t('Use selectors from Views'),
        'endpoint' => $this->t('Use AJAX endpoint for HTML'),
      ],
      '#config_target' => 'ajax_cart_update.settings:update_method',
      '#default_value' => 'selectors',
    ];

    /** @var array<string, mixed> $parentForm */
    $parentForm = parent::buildForm($form, $form_state);

    return $parentForm;
  }

}
