<?php

/**
 * @file
 * Page callback for ajax links.
 */

/**
 * Ajax page callback.
 */
function ajax_register_ajax_page_callback($form, $type) {
  if ($type == 'ajax') {

    $commands = array();

    if ($form == 'password') {

      // User password form requieres this file to be included.
      module_load_include('pages.inc', 'user');

      // Load user password form.
      $form             = drupal_get_form('user_pass');
      $form['#action']  = 'ajax_register/password/nojs';

      // Replace user login block with user password form.
      $commands[] = ajax_command_replace('#user-login-form', render($form));
    }
    elseif ($form == 'login') {

      // Load user login form.
      $form = drupal_get_form('user_login_block');

      // Replace user password form with user login block.
      $commands[] = ajax_command_replace('#user-pass', render($form));
    }
    elseif ($form == 'register') {

      // Load user register form.
      $form            = drupal_get_form('user_register_form');
      $form['#action'] = 'ajax_register/register/nojs';

      // Replace user login block with user register form.
      $commands[] = ajax_command_replace('#user-login-form', render($form));
    }

    // Add prepare function for commands.
    // ajax_prepare_response() appears in Drupal core since Drupal 7.2.
    $drupal_version = (float) VERSION;
    if ($drupal_version >= 7.2) {
      $page       = array('#type' => 'ajax', '#commands' => $commands);
      $commands   = ajax_prepare_response($page);
    }

    // Replace user login form with user register form.
    print ajax_render($commands);
    exit;

  }
  else {
    // If no ajax user redirects to standart drupal forms.
    drupal_goto('user/' . $form);
  }
}
