<?php

/**
 * @file
 * Provides form with AJAX REGISTER module settings.
 */

/**
 * Administrative settings form.
 */
function ajax_register_admin_form($form, $form_state) {

  $form['ajax_register_login'] = array(
    '#type' => 'fieldset',
    '#title' => t('User login form'),
  );

  $form['ajax_register_login']['ajax_register_login_form_redirect'] = array(
    '#type' => 'textfield',
    '#title' => t('Login form redirect url'),
    '#description' => t('Url that the user will be redirected after a successful login. Leave empty for simple page reload.'),
    '#default_value' => variable_get('ajax_register_login_form_redirect', ''),
  );

  $form['ajax_register_register'] = array(
    '#type' => 'fieldset',
    '#title' => t('User register form'),
  );

  $form['ajax_register_register']['ajax_register_register_form_redirect'] = array(
    '#type' => 'textfield',
    '#title' => t('Register form redirect url'),
    '#description' => t('Url that the user will be redirected after a successful registration. Leave empty for simple page reload. Enter @no_redirect for no redirect.',
      array('@no_redirect' => '<noredirect>')),
    '#default_value' => variable_get('ajax_register_register_form_redirect', ''),
  );

  $form['ajax_register_register']['ajax_register_register_form_hide'] = array(
    '#type' => 'checkbox',
    '#title' => t('Hide register form after successfull registration.'),
    '#description' => t('Node that this option works only if @noredirect option selected for register form redirect url.'),
    '#default_value' => variable_get('ajax_register_register_form_hide', TRUE),
  );

  $form['ajax_register_pass'] = array(
    '#type' => 'fieldset',
    '#title' => t('User restore password form'),
  );

  $form['ajax_register_pass']['ajax_register_pass_form_hide'] = array(
    '#type' => 'checkbox',
    '#title' => t('Hide Restore password form after successfull Restore password form submit.'),
    '#default_value' => variable_get('ajax_register_pass_form_hide', FALSE),
  );

  return system_settings_form($form);
}
