<?php

/**
 * @file
 * Page callback for ajax links.
 */

/**
 * Returns USER LOGIN / REGITER / PASSWORD form.
 * @param $form_type
 *   Type of form that should be loaded.
 * @param $js
 *   Show whether user has enabled js in his browser.
 */
function ajax_register_page_callback($form_type, $js) {

  if ($js == 'ajax') {

    if ($form_type == 'password') {
      // Show USER PASSWORD form.
      module_load_include('pages.inc', 'user');
      $form = drupal_get_form('user_pass');
    }
    elseif ($form_type == 'register') {
      // Show USER REGISTER form.
      $form = drupal_get_form('user_register_form');
    }
    elseif ($form_type == 'login') {
      // Show USER LOGIN form.
      $form = drupal_get_form('user_login');
    }

    // Create ajax response.
    $commands   = array();
    $commands[] = ajax_command_html('#ajax-register-popup', render($form));
    $commands[] = ajax_command_invoke('#ajax-register-popup', 'dialog', array('open'));
    return array('#type' => 'ajax', '#commands' => $commands);
  }
  elseif ($js == 'nojs') {
    // If user has no js support redirect him to standart drupal forms.
    drupal_goto('user/' . $form_type);
  }
}
