<?php

/**
 * @file
 * Page callback for ajax links.
 */

/**
 * Returns USER LOGIN / REGITER / PASSWORD form.
 * @param $form_type
 *   Type of form that should be loaded.
 * @param $js
 *   Show whether user has enabled js in his browser.
 */
function ajax_register_page_callback($form_type, $js) {

  // Check whether js is enabled.
  if ($js) {

    // Include ctools modal plugin.
    ctools_include('modal');

    $form_state = array('ajax' => TRUE);

    // Array with ajax response.
    $commands = array();

    if ($form_type == 'password') {
      // Show USER PASSWORD form.
      module_load_include('pages.inc', 'user');
      $form_state['title'] = t('Request new password');
      $commands = ctools_modal_form_wrapper('user_pass', $form_state);
    }
    elseif ($form_type == 'register') {
      // Show USER REGISTER form.
      $form_state['title'] = t('Create new account');
      $commands = ctools_modal_form_wrapper('user_register_form', $form_state);
    }
    elseif ($form_type == 'login') {
      // Show USER LOGIN form.
      $form_state['title'] = t('Log In');
      $commands = ctools_modal_form_wrapper('user_login', $form_state);
    }

    // If form was submited.
    if (!empty($form_state['executed'])) {

      // Include additinal ajax commands.
      ctools_include('ajax');
      $redirect_behavior = variable_get('ajax_register_' . $form_type . '_redirect_behavior', 'default');
      $redirect_url = variable_get('ajax_register_' . $form_type . '_redirect_url', '');
      // Use the form state's redirect url for default behavior.
      if ($redirect_behavior == 'default' && !empty($form_state['redirect'])) {
        $redirect_url = $form_state['redirect'];
      }
      // Refresh the page as a fallback redirect behavior.
      // This can happen if the form state does not have a redirect.
      else {
        $redirect_behavior = 'refresh';
      }

      // Provide additional logic and titles for different form types.
      switch ($form_type) {
        case 'password':
          $title = t('Successful password request');
          break;
        case 'register':
          $title = t('Successful registration');
          break;
        case 'login':
          $title = t('Successful login');
          $message = 'Login was successful.';
          if ($redirect_behavior == 'refresh') {
            $message .= ' Page will now be reloaded.';
          }
          elseif ($redirect_behavior == 'default' || $redirect_behavior == 'custom') {
            $message .= ' Page will now be redirected.';
          }
          drupal_set_message(check_plain(t($message)));
          $commands[] = ctools_modal_command_display($title, theme('status_messages'));
          break;
      }

      // Send ajax command to modal based on redirect behavior.
      switch ($redirect_behavior) {
        case 'none':
          $commands[] = ctools_modal_command_display($title, theme('status_messages'));
          break;
        case 'refresh':
          $commands[] = ctools_ajax_command_reload();
          break;
        // Redirect to URL supplied from default or custom redirect behavior.
        default:
          $commands[] = ctools_ajax_command_redirect($redirect_url);
          break;
      }
    }
    return array('#type' => 'ajax', '#commands' => $commands);
  }
  else {
    // If user has no js support redirect him to standart drupal forms.
    drupal_goto('user/' . $form_type);
  }
}
