<?php

namespace Drupal\alert_message\PageCache;

use Drupal\Core\PageCache\RequestPolicyInterface;
use Symfony\Component\HttpFoundation\Request;

/**
 * Reject when the alertMessageClosed cookie is present.
 */
class AlertMessageDismissedRequestPolicy implements RequestPolicyInterface {

  /**
   * {@inheritdoc}
   */
  public function check(Request $request) {
    // For anonymous users, Internal Page Cache will always
    // render the cached page, we need to deny the cache and let
    // the Dynamic Page Cache take over.
    if ($request->cookies->has('alertMessageClosed')) {
      return static::DENY;
    }
  }

}
