(function (Drupal, drupalSettings, once) {
  Drupal.behaviors.resetColorDefaults = {
    attach: function (context) {
      const buttons = once('reset-color-click', '#reset-default-colors', context);

      buttons.forEach((button) => {
        button.addEventListener('click', function (e) {
          e.preventDefault();

          const defaults = drupalSettings.dg_theme0002?.defaultColors || {};

          Object.entries(defaults).forEach(([key, value]) => {
            const input = context.querySelector(`input[name="${key}"]`);
            if (input) {
              input.value = value;
            }
          });

          const messageDiv = document.createElement('div');
          messageDiv.className = 'color-reset-message';
          messageDiv.textContent = 'Los colores se restablecieron a sus valores por defecto.';

          messageDiv.style.marginBottom = '1em';
          messageDiv.style.padding = '1em';
          messageDiv.style.backgroundColor = '#dff0d8';
          messageDiv.style.border = '1px solid #d6e9c6';
          messageDiv.style.color = '#3c763d';
          messageDiv.style.borderRadius = '4px';
          messageDiv.style.opacity = '1';
          messageDiv.style.transition = 'opacity 0.5s ease';

          const parent = button.parentNode;
          const existing = parent.querySelector('.color-reset-message');
          if (existing) existing.remove();

          parent.insertBefore(messageDiv, button);

          setTimeout(() => {
            messageDiv.style.opacity = '0';
            setTimeout(() => messageDiv.remove(), 500);
          }, 3000);
        });
      });
    }
  };
})(Drupal, drupalSettings, once);
