<?php

namespace Drupal\alogin\Routing;

use Drupal\Core\Routing\RouteSubscriberBase;
use Symfony\Component\Routing\RouteCollection;
use Drupal\Core\Routing\RoutingEvents;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

/**
 * Listens to the dynamic route events.
 */
class AloginRouteSubscriber extends RouteSubscriberBase implements EventSubscriberInterface {

  /**
   * {@inheritdoc}
   */
  protected function alterRoutes(RouteCollection $collection) {
    // Redirect the user.login.http route to custom protected controller.
    if ($route = $collection->get('user.login.http')) {
      $route->setDefault('_controller', '\Drupal\alogin\Controller\MfaLoginController::validateLoginRequest');
    }
  }

  /**
   * {@inheritdoc}
   */
  public static function getSubscribedEvents(): array {
    $events[RoutingEvents::ALTER][] = ['onAlterRoutes', -100];
    return $events;
  }

}
