<?php

function alogin_settings_form($form, &$form_state, $user_id) {
  $alogin = new Alogin($user_id);
  $form_state['uid'] = $user_id;
  $settings = $alogin->select(['enabled']);
  $form = [];

  $form['enable'] = [
    '#type' => 'checkbox',
    '#title' => t('Enable 2FA'),
    '#description' => t('Enables two-factor authentication via authenticator apps.'),
    '#default_value' => $settings['enabled'],
  ];

  $form['2fa'] = [
    '#type' => 'fieldset',
    '#title' => t('2FA Settings'),
    '#states' => [
      'visible' => [
        ':input[name="enable"]' => ['checked' => TRUE]
      ],
      'required' => [
        ':input[name="enable"]' => ['checked' => TRUE]
      ]
    ]
  ];

  $form['2fa']['qr'] = [
    '#type' => 'markup',
    '#markup' => "<img src='". $alogin->getQr() ."' alt='QR'>"
  ];

  $form['2fa']['otp'] = [
    '#type' => 'textfield',
    '#title' => t('OTP'),
  ];

  $form['actions'] = [
    '#type' => 'actions',
    'submit' => [
      '#type' => 'submit',
      '#value' => t('Save'),
    ],
  ];

  return $form;
}

function alogin_settings_form_validate($form, &$form_state) {
  $alogin = new Alogin($form_state['uid']);
  if ($form_state['values']['enable'] && empty($form_state['values']['otp'])) {
    form_set_error('otp', t('OTP field is required.'));
  }
  if ($form_state['values']['enable'] && $alogin->check($form_state['values']['otp']) == false) {
    form_set_error('otp', t('OTP is invalid.'));
  }
}

function alogin_settings_form_submit($form, &$form_state) {
  $alogin = new Alogin($form_state['uid']);
  $alogin->enable($form_state['values']['enable']);

  $message = t('Two-factor authentication has been disabled on your account.');

  if ($form_state['values']['enable']) {
    $message = t('Two-factor authentication has been enabled on your account.');
  }

  drupal_set_message($message);
}
