<?php

use PragmaRX\Google2FAQRCode\Google2FA;

class Alogin {
  protected $secret, $issuer, $currentUser, $uid = 0;
  protected $table = 'alogin_user_settings';

  public function __construct($uid) {
    global $user;
    $this->uid = $uid;
    $this->currentUser = $user;
    $this->issuer = variable_get('site_name');
    $this->secret = $this->getSecret() ? $this->getSecret() : $this->setSecret();
  }

  public function getQr() {
    $g = new Google2FA();
    return $g->getQRCodeInline($this->currentUser->name, str_replace(' ', '', $this->issuer) , $this->secret);
  }

  public function check($code) {
    $g = new Google2FA();
    return $g->verifyKey($this->secret, $code);
  }

  public function select($fields = []) {
    $select = db_select($this->table, 'a')
              ->fields('a', $fields)
              ->condition('uid', $this->uid, '=')
              ->execute()
              ->fetchAssoc();
    return $select;
  }

  public function getSecret() {
    if($secret = $this->select(['secret'])) {
      return $secret['secret'];
    }
    return false;
  }

  public function setSecret() {
    $g = new Google2FA();
    $secret = $g->generateSecretKey(64);
    db_insert($this->table)->fields([
      'uid' => $this->uid,
      'secret' => $secret,
    ])->execute();
    return $secret;
  }

  public function enable($enable = 0) {
    return db_update($this->table)
          ->fields(['enabled' => $enable])
          ->condition('uid', $this->uid, '=')
          ->execute();
  }

  public function enabled() {
    $enabled = db_select($this->table, 'a')
          ->fields('a', ['enabled'])
          ->condition('uid', $this->uid, '=')
          ->execute()
          ->fetchAssoc();
    return $enabled['enabled'];
  }
}
