<?php

namespace Drupal\alt_login\Plugin\EntityReferenceSelection;

use Drupal\user\Plugin\EntityReferenceSelection\UserSelection;

/**
 * Provides specific access control for the user entity type.
 *
 * @todo inject AltLoginMethodManager
 */
#[EntityReferenceSelection(
  id: "default:altlogin",
  label: new TranslatableMarkup("AltLogin user display name"),
  entity_types: ["user"],
  group: "alt_login",
  weight: 2
)]
class AltLoginUserSelection extends UserSelection {

  /**
   * {@inheritdoc}
   *
   * @note This doesn't inherit from its ancestors because we're not presuming
   * to search on the user name.
   */
  protected function buildEntityQuery($match = NULL, $match_operator = 'CONTAINS') {
    $query = $this->entityTypeManager->getStorage('user')->getQuery()->accessCheck(1);
    $query->addTag('user_access');
    $query->addTag('entity_reference');
    $query->addMetaData('entity_reference_selection_handler', $this);

    $configuration = $this->getConfiguration();
    // Add the sort option.
    if ($configuration['sort']['field'] !== '_none') {
      $query->sort($configuration['sort']['field'], $configuration['sort']['direction']);
    }
    if (!$configuration['include_anonymous']) {
      $query->condition('uid', 0, '<>');
    }
    if (!empty($configuration['filter']['role'])) {
      $query->condition('roles', $configuration['filter']['role'], 'IN');
    }
    if ($match) {
      $or = $query->orConditionGroup();
      foreach (\Drupal::service('alt_login.method_manager')->activePlugins() as $plugin) {
        $plugin->entityQuery($or, $match);
      }
      $query->condition($or);
    }
    return $query;
  }

}
