<?php

/**
 * When we have field tokens in core this module won't need to provide its own token
 */

/**
 * Implements hook_token_info().
 */
function alt_login_token_info() {
  return [
    'types' => $types,
    'tokens' => [
      'user' => [
        'alt-login' => [
          'name' => t('Alternative login name'),
          'description' => t('An alternative value with which the user can log in')
        ]
      ]
    ]
  ];
}

/**
 * Implements hook_tokens().
 */
function alt_login_tokens($type, $tokens, array $data = array(), array $options = array()) {
  $replacements = [];
  if ($type == 'user' && !empty($data['user'])) {
    if ($original = @$tokens['alt-login']) {
      $fieldname = Drupal::config('alt_login.config')->get('userfieldname');
      $name = $data['user']->get($fieldname)->value;
      $extra = t('or !name', ['!name' => $name]);
      $replacements[$original] = $extra;
    }
  }
  return $replacements;
}