<?php

namespace Drupal\alt_login\Plugin\AltLoginMethod;

use Drupal\alt_login\AltLoginMethodInterface;
use Drupal\user\UserInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Egulias\EmailValidator\EmailValidatorInterface;
use Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\Core\Plugin\ContainerFactoryPluginInterface;

/**
 * Plugin implementation for logging in with the user name as an alias.
 *
 * @AltLoginMethod(
 *   id = "email",
 *   label = @Translation("Email"),
 *   description = @Translation("Login with the user's email")
 * )
 */
class Email extends Username implements AltLoginMethodInterface, ContainerFactoryPluginInterface {

  /**
   * @var EmailValidatorInterface
   */
  private $emailValidator;
  /**
   * @var EntityTypeManagerInterface
   */
  private $entityTypeManager;

  /**
   * @param EntityTypeManagerInterface $entity_type_manager
   * @param AltLoginMethod\EmailValidator $email_validator
   */
  function __construct(EntityTypeManagerInterface $entity_type_manager, EmailValidatorInterface $email_validator) {
    $this->entityTypeManager = $entity_type_manager;
    $this->emailValidator = $email_validator;
  }

  /**
   *
   * @param ContainerInterface $container
   * @param array $configuration
   * @param string $plugin_id
   * @param array $plugin_definition
   * @return static
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition) {
    return new static (
      $container->get('entity_type.manager'),
      $container->get('email.validator')
    );
  }

  /**
   * {@inheritDoc}
   */
  function applies($alias) {
    return $this->emailValidator->isValid($alias);
  }


  /**
   * {@inheritDoc}
   */
  function getUsernameFromAlias($alias) {
    $users = $this->entityTypeManager->getStorage('user')->loadByProperties(['mail' => $alias]);
    if (count($users)) {
      return reset($users)->getUsername();
    }
  }

  /**
   * {@inheritDoc}
   */
  function getAlias(UserInterface $user){
    return $user->getEmail();
  }

}
