<?php

namespace Drupal\alt_login\Plugin\AltLoginMethod;

use Drupal\alt_login\AltLoginMethodInterface;
use Drupal\user\UserInterface;

/**
 * Plugin implementation for logging in with the user name as an alias.
 *
 * @AltLoginMethod(
 *   id = "username",
 *   label = @Translation("Username (Default)"),
 *   description = @Translation("Normal Drupal login")
 * )
 */
class Username implements AltLoginMethodInterface {


  /**
   * {@inheritDoc}
   */
  function dedupeAlias(UserInterface $user) {
    // This is checked by the user module and database anyway.
    return FALSE;
  }

  /**
   * {@inheritDoc}
   */
  function applies($alias) {
    return TRUE;
  }


  /**
   * {@inheritDoc}
   */
  function getUsernameFromAlias($alias) {
    return $alias;
  }


  /**
   * {@inheritDoc}
   */
  function getAlias(UserInterface $user){
    return $user->getUsername();
  }

}
