<?php

namespace Drupal\alt_login\Plugin\AltLoginMethod;

use Drupal\alt_login\AltLoginMethodInterface;
use Drupal\user\UserInterface;
use Drupal\user\Entity\User;

/**
 * Plugin implementation for logging in with the user name as an alias.
 *
 * @AltLoginMethod(
 *   id = "uid",
 *   label = @Translation("User ID"),
 *   description = @Translation("Drupal's database key")
 * )
 */
class Uid extends Username implements AltLoginMethodInterface {

  /**
   * {@inheritDoc}
   */
  function applies($alias) {
    $num = (int)$alias;
    return $num == $alias;
  }

  /**
   * {@inheritDoc}
   */
  function getUsernameFromAlias($alias) {
    if ($user = User::load($alias)) {
      return $user->getUsername();
    }
  }

  /**
   * {@inheritDoc}
   */
  function getAlias(UserInterface $user){
    return $user->id();
  }

}
