<?php

namespace Drupal\alt_login;

use Drupal\user\UserInterface;
use Drupal\Core\Entity\Query\Sql\Condition;

/**
 * Jnterface for AltLoginMethod plugins.
 */
interface AltLoginMethodInterface {

  /**
   * Check that an account's aliases can't be shared with any other users.
   *
   * @param UserInterface $user
   *
   * @return string | null
   *   If another account has the same alias, flag the error, on this fieldname.
   */
  function dedupeAlias(UserInterface $user);

  /**
   * Check wheteher the given string is likely to be an alias generated by this
   * plugin. i.e. whether it is worth testing.
   *
   * @param string $alias
   *
   * @return bool
   */
  function applies($alias);

  /**
   * When validating a login, find which user it applies to.
   *
   * @param string $name
   *
   * @return string | NULL
   *   The real username or Null if the alias doesn't correspond to a user.
   */
  function getUsernameFromAlias($alias);

  /**
   * Get the alias for the given user.
   *
   * @param UserInterface $user
   *
   * @return string
   */
  function getAlias(UserInterface $user);


  /**
   * Add conditions to an EntityQuery OR group
   *
   * @param Condition $or_group
   * @param string $match
   * @param Query $query
   */
  function entityQuery(Condition $or_group, $match);
}
