<?php

namespace Drupal\alt_text_validation\Controller;

use Drupal\alt_text_validation\Service\BatchProcessor;
use Drupal\Core\Controller\ControllerBase;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\HttpFoundation\RedirectResponse;

/**
 * The batch process controller AltTextValidationAudit.
 */
class AltTextValidationAudit extends ControllerBase {

  /**
   * The batch processor service.
   *
   * @var \Drupal\alt_text_validation\Service\BatchProcessor
   */
  protected $batchProcessor;

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    return new static(
      $container->get('alt_text_validation.batch_processor')
    );
  }

  /**
   * Constructs the AltTextValidationAudit controller.
   *
   * @param Drupal\alt_text_validation\Service\BatchProcessor $batchProcessor
   *   The batch processor service.
   */
  public function __construct(BatchProcessor $batchProcessor) {
    $this->batchProcessor = $batchProcessor;
  }

  /**
   * Processes the batch.
   *
   * @return \Symfony\Component\HttpFoundation\RedirectResponse|null
   *   The path to redirect to upon completion of the batch.
   */
  public function batchProcess(): RedirectResponse|null {
    return $this->batchProcessor->batchProcess();
  }

}
