<?php

namespace Drupal\alt_text_validation\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Alt Text Validation Setting form.
 */
class AltTextValidationSettingsForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'alt_text_validation_enabled_form';
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return ['alt_text_validation.settings'];
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $form = parent::buildForm($form, $form_state);
    $form['#title'] = $this->t('Alt Text Validation Settings');
    $form['alt_text_validation_enabled_group'] = [
      '#type' => 'fieldset',
    ];
    $form['alt_text_validation_enabled_group']['alt_text_validation_enabled'] = [
      '#prefix' => '<div class="container-inline">',
      '#title' => $this->t('Validate alt text on save'),
      '#type' => 'radios',
      '#options' => [
        '1' => $this->t('On (all active rules applied)'),
        '0' => $this->t('Off (no rules applied)'),
      ],
      '#default_value' => $this->config('alt_text_validation.settings')->get('alt_text_validation_enabled') ?? 0,
      '#suffix' => '</div>',
    ];
    $form['alt_text_validation_enabled_group']['cron_enabled'] = [
      '#prefix' => '<div class="container-inline">',
      '#title' => $this->t('Rebuild alt text report on cron'),
      '#type' => 'radios',
      '#options' => [
        '1' => $this->t('On'),
        '0' => $this->t('Off'),
      ],
      '#default_value' => $this->config('alt_text_validation.settings')->get('cron_enabled') ?? 0,
      '#suffix' => '</div>',
    ];
    $form['alt_text_validation_enabled_group']['cron_delay'] = [
      '#prefix' => '<div class="container-inline">',
      '#title' => $this->t('Days between rebuild'),
      '#type' => 'number',
      '#attributes' => [
        'data-type' => 'number',
      ],
      '#size' => 3,
      '#max' => 365,
      '#min' => 1,
      '#default_value' => $this->config('alt_text_validation.settings')->get('cron_delay') ?? 7,
      '#suffix' => '</div>',
      '#states' => [
        // Show this textfield only if the radio '1' is selected above.
        'visible' => [
          ':input[name="cron_enabled"]' => ['value' => '1'],
        ],
      ],
    ];
    $form['alt_text_validation_enabled_group_alert headings'] = [
      '#type' => 'fieldset',
      '#title' => $this->t('Customize alert headings'),
    ];
    $form['alt_text_validation_enabled_group_alert headings']['heading_warn'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Warn heading text'),
      '#default_value' => $this->config('alt_text_validation.settings')->get('heading_warn') ? $this->config('alt_text_validation.settings')->get('heading_warn') : $this->t('Alt text warnings, please consider addressing them.'),
    ];
    $form['alt_text_validation_enabled_group_alert headings']['heading_prevent'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Prevent heading text'),
      '#default_value' => $this->config('alt_text_validation.settings')->get('heading_prevent') ? $this->config('alt_text_validation.settings')->get('heading_prevent') : $this->t('Alt text errors found. Page can not be saved.'),
    ];
    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $config = $this->configFactory()->getEditable('alt_text_validation.settings');
    $config->set('alt_text_validation_enabled', $form_state->getValue('alt_text_validation_enabled'))
      ->set('cron_enabled', $form_state->getValue('cron_enabled'))
      ->set('cron_delay', $form_state->getValue('cron_delay'))
      ->set('heading_warn', $form_state->getValue('heading_warn'))
      ->set('heading_prevent', $form_state->getValue('heading_prevent'))
      ->save();
    parent::submitForm($form, $form_state);
  }

}
