<?php

namespace Drupal\alt_text_validation\Service;

/**
 * Class for Audit Storage to read and write entries to the audit table.
 */
interface AuditStorageInterface {

  /**
   * Constructs the BatchOperations service.
   *
   * @param string $filename
   *   The image filename.
   * @param string $alt_text
   *   The value of the alt attribute.
   * @param int $warnings
   *   The number of warnings this alt causes.
   * @param int $violations
   *   The number of violations this alt causes.
   * @param string $title
   *   The value of the title attribute.
   * @param string $entity
   *   The entity (node, media, taxonomy_term, paragraph...) where this exists.
   * @param string $bundle
   *   The bundle / vocabulary where this image exists.
   * @param int $id
   *   The id of the entity.
   * @param string $field_name
   *   The machine name of the field where this exists.
   * @param string $file_source
   *   The full path / location of the file including filename.
   * @param array $violation_list
   *   The array list of validation errors.
   */
  public function writeAuditRow(
    string $filename,
    string $alt_text,
    int $warnings,
    int $violations,
    string $title,
    string $entity,
    string $bundle,
    int $id,
    string $field_name,
    string $file_source,
    array $violation_list,
  ): void;

  /**
   * Empty the table of all records.
   */
  public function truncateTable(): void;

  /**
   * Truncate the table and populate with test data.
   *
   * @todo move this to the unit test when there is one.
   */
  public function generateTestData(): void;

}
