<?php

namespace Drupal\Tests\alt_text_validation\Functional;

use Drupal\Tests\BrowserTestBase;

/**
 * Tests for the report side of the alt_text_validation module.
 *
 * @group alt_text_validation
 */
class ReportTest extends BrowserTestBase {

  /**
   * Modules to install.
   *
   * @var array
   */
  protected static $modules = [
    'alt_text_validation',
    'user',
    'field',
    'views',
    'views_data_export',
  ];

  /**
   * The theme to default to during tests.
   *
   * @var string
   */
  protected $defaultTheme = 'stark';

  /**
   * A user permed for viewing the alt text validation.
   *
   * @var \Drupal\user\UserInterface
   */
  private $permedUser;

  /**
   * A non-permed user.
   *
   * @var \Drupal\user\UserInterface
   */
  private $normalUser;

  /**
   * Perform initial setup tasks that run before every test method.
   */
  public function setUp(): void {
    parent::setUp();
    $this->permedUser = $this->DrupalCreateUser([
      'view alt text validation reports',
    ]);
    $this->normalUser = $this->DrupalCreateUser([]);
  }

  /**
   * Tests that the report page can be reached with the right perms.
   */
  public function testReportPageExists(): void {
    $this->drupalLogin($this->permedUser);
    $this->drupalGet('admin/reports/alt-text-report');
    $this->assertSession()->statusCodeEquals(200);
    // Assert no warnings or errors.
    $this->assertSession()->statusMessageNotExists('warning');
    $this->assertSession()->statusMessageNotExists('error');

    // Validate the header:
    // Validate that we have a status in the View header.
    $this->assertSession()->pageTextContains('Audit status:');
    // Validate that we have a rebuild link in the View header.
    $this->assertSession()->linkByHrefExists('/admin/reports/alt-text-report/rebuild', 0, 'Rebuild button link not found.');

    // Validate the filters:
    // Validate that one of the many filter fields is present.
    $this->assertSession()->fieldExists('edit-violations');
    // Validate that we have a filter submit.
    $this->assertSession()->elementExists('css', '#edit-submit-alt-text-report');

    // Validate that we have a no results message.
    $this->assertSession()->pageTextContains('There are no results, that match no filter.');

    // Check for CSV download page.
    $this->drupalGet('admin/reports/alt-text-report/csv');
    $this->assertSession()->statusCodeEquals(200);
  }

  /**
   * Tests that the Report page can't be reached with without perms.
   */
  public function testSettingsPageAccessDenied(): void {
    $this->drupalLogin($this->normalUser);
    $this->drupalGet('admin/reports/alt-text-report');
    $this->assertSession()->statusCodeEquals(403);

    // Check for CSV page is not available.
    $this->drupalGet('admin/reports/alt-text-report/csv');
    $this->assertSession()->statusCodeEquals(403);
  }

  /**
   * Set to TRUE to strict check all configuration saved.
   *
   * Needed to disable schema validation because it errors on validating View.
   *
   * @var bool
   *
   * @see \Drupal\Core\Config\Development\ConfigSchemaChecker
   */
  protected $strictConfigSchema = FALSE;

}
