<?php

namespace Drupal\Tests\alt_text_validation\Functional;

use Drupal\Tests\BrowserTestBase;

/**
 * Tests for the admin/settings side of the alt_text_validation module.
 *
 * @group alt_text_validation
 */
class AdminTest extends BrowserTestBase {

  /**
   * Modules to install.
   *
   * @var array
   */
  protected static $modules = [
    'alt_text_validation',
    'user',
    'field',
    'views',
    'views_data_export',
  ];

  /**
   * The theme to default to during tests.
   *
   * @var string
   */
  protected $defaultTheme = 'stark';

  /**
   * A user permed for administrating alt_text_validation.
   *
   * @var \Drupal\user\UserInterface
   */
  private $permedUser;

  /**
   * A non-permed user.
   *
   * @var \Drupal\user\UserInterface
   */
  private $normalUser;

  /**
   * Perform initial setup tasks that run before every test method.
   */
  public function setUp(): void {
    parent::setUp();
    $this->permedUser = $this->DrupalCreateUser([
      'administer alt text validation',
    ]);
    $this->normalUser = $this->DrupalCreateUser([]);
  }

  /**
   * Tests that the settings page can be reached with the right perms.
   */
  public function testSettingsPageExists(): void {
    $this->drupalLogin($this->permedUser);
    $this->drupalGet('admin/config/content/alt-text-validation');
    $this->assertSession()->statusCodeEquals(200);
    // Assert no warnings or errors.
    $this->assertSession()->statusMessageNotExists('warning');
    $this->assertSession()->statusMessageNotExists('error');
  }

  /**
   * Tests that the settings page can't be reached with without perms.
   */
  public function testSettingsPageAccessDenied(): void {
    $this->drupalLogin($this->normalUser);
    $this->drupalGet('admin/config/content/alt-text-validation');
    $this->assertSession()->statusCodeEquals(403);
  }

  /**
   * Set to TRUE to strict check all configuration saved.
   *
   * Needed to disable schema validation because it errors on validating View.
   *
   * @var bool
   *
   * @see \Drupal\Core\Config\Development\ConfigSchemaChecker
   */
  protected $strictConfigSchema = FALSE;

}
