<?php

namespace Drupal\alt_text_validation\Plugin\Validation\Constraint;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Symfony\Component\Validator\Constraint;

/**
 * Constraint to cover all the alt text rules.
 */
#[\Drupal\Core\Validation\Attribute\Constraint(
  id: 'AltTextRules',
  label: new TranslatableMarkup('Alt Text Rules', [], ['context' => 'Validation']),
  type: FALSE
)]
class AltTextRulesConstraint extends Constraint {
  // @todo Setting the message as a single var is not going to work because the
  // possible messages are dynamic, coming from the rules that fail
  /**
   * The message that will be shown if the value is not an integer.
   *
   * @var string
   */
  public $notInteger = '%value is not an integer';

}
