<?php

namespace Drupal\alt_text_validation\Plugin\Validation\Constraint;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Symfony\Component\Validator\Constraint;

/**
 * Constraint to cover all the alt text rules.
 *
 * Setting the message as a single var does not work because multiple rules
 * might be violated and only the validator knows how many and which ones.
 */
#[\Drupal\Core\Validation\Attribute\Constraint(
  id: 'AltTextRules',
  label: new TranslatableMarkup('Alt Text Rules', [], ['context' => 'Validation']),
  type: FALSE
)]
class AltTextRulesConstraint extends Constraint {

}
