<?php

namespace Drupal\Tests\alt_text_validation\Kernel;

use Drupal\KernelTests\KernelTestBase;
use Drupal\alt_text_validation\Entity\AltTextRule;

/**
 * Tests the Alt-Text Rule configuration entity.
 *
 * @group alt_text_validation
 */
class AltTextRuleEntityTest extends KernelTestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'system',
    'alt_text_validation',
  ];

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();
    $this->installConfig(['system']);
  }

  /**
   * Tests CRUD operations for alt-text rules.
   */
  public function testAltTextRuleCrud() {
    // Create an alt-text rule.
    $altTextRule = AltTextRule::create([
      'id' => 'content_length_lt_150',
      'label' => 'Test Rule',
      'rule_type' => 'length_limit',
      'content_char_limit' => 150,
      'text_to_compare' => '',
      'violation_action' => 'warning',
      'violation_message' => 'Content exceeds character limit',
    ]);

    // Saving the rule.
    $altTextRule->save();
    $this->assertNotNull($altTextRule->id());

    // Loading the rule.
    $loadedRule = AltTextRule::load($altTextRule->id());
    $this->assertNotNull($loadedRule);
    $this->assertInstanceOf(AltTextRule::class, $loadedRule);
    $this->assertEquals(150, $loadedRule->getContentCharLimit());

    // Updating the rule.
    $loadedRule->setContentCharLimit(200)->save();
    $updatedRule = AltTextRule::load($loadedRule->id());
    $this->assertEquals(200, $updatedRule->getContentCharLimit());

    // Deleting the rule.
    $loadedRule->delete();
    $deletedRule = AltTextRule::load($loadedRule->id());
    $this->assertNull($deletedRule);
  }

  /**
   * Tests alt-text rule validation.
   */
  public function testTextRuleValidation() {
    // Test content character limit rule.
    $charLimitRule = AltTextRule::create([
      'id' => 'content_length_lt_150',
      'label' => 'Content Character Limit Rule',
      'rule_type' => 'length_limit',
      'content_char_limit' => 150,
      'text_to_compare' => '',
      'violation_action' => 'warning',
      'violation_message' => 'Content exceeds character limit',
    ]);
    $charLimitRule->save();
    $this->assertNotNull($charLimitRule->id());
  }

}
