<?php

namespace Drupal\alt_text_validation;

use Drupal\Core\Config\Entity\ConfigEntityListBuilder;
use Drupal\Core\Entity\EntityInterface;

/**
 * Manages the Alt-Text Rule List Builder.
 */
class AltTextRuleListBuilder extends ConfigEntityListBuilder {

  /**
   * {@inheritdoc}
   */
  public function buildHeader(): array {
    $header['label'] = $this->t('Label');
    $header['rule_status'] = $this->t('Rule status');
    $header['rule_type'] = $this->t('Rule type');
    $header['comparison'] = $this->t('Comparison');
    return $header + parent::buildHeader();
  }

  /**
   * {@inheritdoc}
   */
  public function buildRow(EntityInterface $entity): array {
    /** @var \Drupal\alt_text_validation\AltTextRuleInterface $entity */
    $row['label'] = $entity->label();
    $row['rule_status'] = $entity->getViolationAction();
    $row['rule_type'] = $entity->getRuleTypeLabel();
    $row['comparison'] = (empty($entity->getContentCharLimit())) ? $entity->getTextToCompare() : "{$entity->getContentCharLimit()} {$this->t('characters')}";

    return $row + parent::buildRow($entity);
  }

}
