
## Introduction

This module helps prevent editors from writing bad alt text
on images. This module does a few things:

- Provide a report of all alt text attached to images for auditing purposes.
   - Filterable
   - Downloadable to CSV
   - Report generation controlled by cron or manual
   - Finds images in ALL image fields, and all text fields that support html across all entities.
- Provide customizable rules to validate alt text against during save.
- Server side validation of the rules against submitted alt
  text upon saving.
    - "Warn" rules do not prevent saving content but give warnings about any issues.
    - "Prevent" rules will not allow saving until the issues are resolved.
    - Individual rules can be turned off.
    - A main switch allows rules validation to be turned off, while still allowing to them to be used by the report,



## Table of contents

- Requirements
- Installation & Configuration
- Alt Text Report
- Drush Commands
- Launch Strategies
- Developers and Contributors

## Requirements

This module requires
  * drupal:field (part of Drupal core)
  * drupal:[views_data_export](https://www.drupal.org/project/views_data_export)


## Installation & Configuration

Configuration steps are minimal:

  1. Install the module as you would any other module.
  2. Go to /admin/config/content/alt-text-validation and configure to your needs.
  3. Assign permissions for administering the module and viewing the report to Roles.
  4. Go to /admin/config/content/alt-text-validation/rules to add/edit rules. Give careful thought to which rules should be "warn" and which rules should be "prevent".


## Report

The Alt Text Audit report is present at Reports >> Alt Text Report (/admin/reports/alt-text-report) for properly permed users.  This report is a View that can be modified if needed.  It requires the Auditor job be run to populate the report. The audit report will
show any occurrences of image containing fields on any entity.  It also includes any html image tags found within text fields on any entity.  Scroll to the bottom of the report to see the CSV icon to download a CSV of the current View.

There are three ways to initialize the report generation.  Depending on the
size of your site, it may be an intensive process.
To populate the report you will need to either:

1. Enable report generation via cron (/admin/config/content/alt-text-validation) - It will begin the generation with the next cron run.
2. On the report page, there is a button to run the report using a batch process.
3. Via Drush command.
```
drush alt-text-validation:queue-audit
drush cron
```
It uses the Queue API and may take several cron runs to fully populate the report. You can assess the progress by `drush queue:list` then look for `atv_entity_instances`
The top of the report contains information about when the report was started and finished.

## Drush Commands

  - drush alt-text-validation:queue-audit - this command queues up the entities to audit.  It requires cron to run (perhaps more than once) to complete the audit.

## Launch Strategies

There are a few possible ways to roll this module out to editors:

  - **Info gathering only** - Add rules, but turn off "Validate alt text on save". This will let you run the report to collect info and strategize what rules you will put in place.
  - **Soft start** - Create only a handful of the most important rules and turn them on as warnings. Gradually change a few rules at a time from "warn" into "prevent".
  - **Hard-line** - Turn it on, add a bunch of Prevent rules and turn on "Validate alt text on save".  It might be painful for editors at first, but will get you to full compliance faster.

  ### Other notes related to approaches

  - Rules can also be about content strategy rather than just accessibility.  Example: Your company has an abbreviation that happens to match a state.  Many screen screen readers will read 'CA' as California, rather than "C A", so you could warn people to use the full name instead of the abbreviation.

## Developers and Contributors

This project uses [ddev-drupal-contrib](https://github.com/ddev/ddev-drupal-contrib)
   - Install ddev locally.
   - Clone the alt_text_validation project repository or any issue fork
   - Refer to the [ddev-drupal-contrib readme](https://github.com/ddev/ddev-drupal-contrib)  file for instructions on using the plugin and the testing tools it provides (phpunit, phpcs, eslint, etc).
