<?php

namespace Drupal\altcolor\Hook;

use Drupal\Core\Hook\Attribute\Hook;
use Drupal\Core\Routing\RouteMatchInterface;
use Drupal\Core\StringTranslation\StringTranslationTrait;

/**
 * Hook implementations for the Alternative color module.
 */
class AltColorHooks {

  use StringTranslationTrait;

  /**
   * Implements hook_help().
   */
  #[Hook('help')]
  public function help($route_name, RouteMatchInterface $route_match) : ?string {
    switch ($route_name) {
      case 'help.page.altcolor':
        $output = '<h2>' . $this->t('About') . '</h2>';
        $output .= $this->t('The Alternative color module allows administrators to change the color scheme of a supported theme from the theme settings page.');

        return $output;
    }
    return NULL;
  }

  /**
   * Implements hook_theme_registry_alter().
   *
   * This hook ensures that this module's preprocess function runs after that of
   * a theme. Doing this allows this module to override the CSS variables that
   * can possibly come from a theme.
   */
  #[Hook('theme_registry_alter')]
  public function altcolorThemeRegistryAlter(&$theme_registry) {
    $hook = 'altcolor_preprocess_html';
    $key = array_search($hook, $theme_registry['html']['preprocess functions']);
    unset($theme_registry['html']['preprocess functions'][$key]);
    $theme_registry['html']['preprocess functions'][] = $hook;
  }

  /**
   * Implements hook_themes_installed().
   */
  #[Hook('themes_installed')]
  public function themesInstalled(): void {
    // @phpstan-ignore globalDrupalDependencyInjection.useDependencyInjection (Core also does not inject dependencies in installation hooks.)
    \Drupal::service('altcolor.manager')->clearCachedDefinitions();
  }

  /**
   * Implements hook_themes_uninstalled().
   */
  #[Hook('themes_uninstalled')]
  public function themesUninstalled(): void {
    // @phpstan-ignore globalDrupalDependencyInjection.useDependencyInjection (Core also does not inject dependencies in installation hooks.)
    \Drupal::service('altcolor.manager')->clearCachedDefinitions();
  }

}
