<?php

namespace Drupal\altcolor\Plugin;

/**
 * Defines an interface for alternative color managers.
 */
interface AltColorPluginManagerInterface {

  /**
   * Gets the color definitions for the active theme.
   *
   * @return \Drupal\altcolor\Plugin\ThemeColorsInterface|null
   *   Array of color definitions, or NULL if no color definitions are found.
   */
  public function getColorDefinitionsForActiveTheme(): ?ThemeColorsInterface;

  /**
   * Gets the color definitions for the specified theme.
   *
   * This method returns an array of color definitions keyed by 'colors' for all
   * the supported colors and 'schemes' for the suggested color schemes. These
   * two values are always present even if their contents are empty.
   *
   * @param string $theme
   *   The theme to retrieve the color definitions for.
   *
   * @return \Drupal\altcolor\Plugin\ThemeColorsInterface|null
   *   Array of color definitions, or NULL if no color definitions are found.
   */
  public function getColorDefinitionsByTheme($theme): ?ThemeColorsInterface;

}
