<?php

namespace Drupal\altcolor\Plugin;

/**
 * Interface for Alternative color ThemeColors plugins.
 */
interface ThemeColorsInterface {

  /**
   * Returns the color names.
   *
   * @return array
   *   The color names.
   */
  public function getColors();

  /**
   * Returns the color schemes.
   *
   * Returns an array with defined color schemes, keyed by name and containing
   * pairs of color names and HEX values.
   *
   * @return array
   *   An array with defined color schemes.
   */
  public function getSchemes();

}
