/**
 * @file
 * Tests of the Alternative Color module preview functionality.
 */

const selectors = {
  iframe: 'iframe[name="altcolor-preview-frame"]',
  colorFields: {
    base: 'input[type="color"][name="altcolor[colors][base]"]',
  },
};

module.exports = {
  '@tags': ['altcolor'],
  before(browser) {
    browser
      .drupalInstall()
      .drupalInstallModule('altcolor')
      .drupalEnableTheme('test_theme_altcolor1');
  },
  after(browser) {
    browser.drupalUninstall();
  },
  'Visit a theme configuration page and change the field values': (browser) => {
    browser.drupalLoginAsAdmin(() => {
      browser
        .drupalRelativeURL('/admin/appearance/settings/test_theme_altcolor1')
        .waitForElementVisible(selectors.iframe)
        .waitForElementVisible(selectors.colorFields.base);

      // Switch to the preview iframe.
      browser.frame(selectors.iframe);
      browser
        .waitForElementPresent('body')
        // Assert that the original base color value is set.
        .expect.element('html')
        .to.have.attribute('style')
        .which.contains('--color-base: #f0f8ff');
      // Return to the parent frame.
      browser.frame(null);

      // Update the color field value.
      browser.waitForElementVisible(selectors.colorFields.base);
      // The setValue function does not work with color fields. Set it manually.
      browser
        .execute(
          function (selector, value) {
            const element = document.querySelector(selector);
            element.value = value;
            element.dispatchEvent(new Event('input', { bubbles: true }));
            element.dispatchEvent(new Event('change', { bubbles: true }));
          },
          [selectors.colorFields.base, '#009cde'],
        )
        .pause(1000);

      // Switch to the preview iframe.
      browser.frame(selectors.iframe);
      browser
        .waitForElementPresent('body')
        // Assert that the new base color value is set.
        .expect.element('html')
        .to.have.attribute('style')
        .which.contains('--color-base: #009cde');
      // Return to the parent frame.
      browser.frame(null);
    });
  },
};
