<?php

namespace Drupal\alter_entity_autocomplete;

use Symfony\Component\DependencyInjection\Reference;
use Drupal\Core\DependencyInjection\ContainerBuilder;
use Drupal\Core\DependencyInjection\ServiceProviderBase;
use Drupal\alter_entity_autocomplete\AlterEntityAutocomplete\AlterEntityAutocompleteMatcher;

/**
 * Service provider to alter the entity autocomplete matcher service.
 *
 * This service provider replaces the core EntityAutocompleteMatcher
 * with our enhanced version that supports direct entity ID/URL/alias input
 * for all core entity types.
 */
class AlterEntityAutocompleteServiceProvider extends ServiceProviderBase {

  /**
   * Alters the container to replace the entity autocomplete matcher service.
   *
   * @param \Drupal\Core\DependencyInjection\ContainerBuilder $container
   *   The container builder.
   */
  public function alter(ContainerBuilder $container) {
    // Do NOT change arguments; just swap the class.
    $definition = $container->getDefinition('entity.autocomplete_matcher');
    $definition->setClass(AlterEntityAutocompleteMatcher::class);

    // Setter injection for extra dependencies
    // (constructor remains core-compatible).
    $definition->addMethodCall('setConfigFactory', [new Reference('config.factory')]);
    $definition->addMethodCall('setModuleHandler', [new Reference('module_handler')]);
    $definition->addMethodCall('setRequestStack', [new Reference('request_stack')]);
    $definition->addMethodCall('setPathValidator', [new Reference('path.validator')]);
    $definition->addMethodCall('setEntityTypeManager', [new Reference('entity_type.manager')]);
  }

}
