<pre>
  ┌───────┐
  │       │
  │  a:o  │  acolono.com
  │       │
  └───────┘
</pre>

# Alttext.ing

A Drupal module that automatically generates alternative text for images using AI-powered image recognition.

## Features

- Automatically generates descriptive alt text for images using an external AI service
- Integrates with Drupal's media management system
- Supports multiple languages
- Processes images asynchronously for better performance
- Provides a user interface for generating and managing alt text

## Requirements

- Drupal 10 or 11
- PHP 8.1 or higher
- An API key for [api.alttext.ing](https://api.alttext.ing)

## Installation

1. Install the module using Composer:
   ```
   composer require drupal/alttexting
   ```

2. Enable the module through the Drupal admin interface or with Drush:
   ```
   drush en alttexting -y
   ```

3. Configure the module at `/admin/config/media/alttexting` with your API credentials and settings.

## Configuration

1. Navigate to `/admin/config/media/alttexting`
2. Enter your API key and configure the following settings:
   - API endpoint URL
   - Local development requirements

## Usage

### Manual Generation
1. Edit any media entity with an image field
2. Click the "Generate Alt Text" button
3. Review and save the generated alt text

## Troubleshooting

- **API Connection Issues**: Verify your API key and endpoint URL in the module settings.
- **Missing Alt Text**: Check the Drupal logs for any error messages related to the alt text generation.
- **Localhost**: If you are using localhost, you need to enable development requirements in the module settings.

by acolono GmbH
---------------

~~we build your websites~~
we build your business

hello@acolono.com

www.acolono.com
www.twitter.com/acolono
www.drupal.org/acolono-gmbh


