<?php

namespace Drupal\alttexting\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Configure Alttext.ing settings for this site.
 */
class AltTextSettingsForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'alttexting_settings';
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return ['alttexting.settings'];
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $config = $this->config('alttexting.settings');

    $form['general'] = [
      '#type' => 'details',
      '#title' => $this->t('General Settings'),
      '#open' => TRUE,
    ];

    $form['general']['api_key'] = [
      '#type' => 'textfield',
      '#title' => $this->t('API Key'),
      '#default_value' => $config->get('api_key'),
      '#description' => $this->t('API key for the alt text service.'),
      '#required' => TRUE,
    ];

    $form['general']['autogenerate_on_save'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Autogenerate on save'),
      '#description' => $this->t('Autogenerate alt text on media save.'),
      '#default_value' => $config->get('autogenerate_on_save'),
    ];

    $form['development'] = [
      '#type' => 'details',
      '#title' => $this->t('Development'),
      '#open' => TRUE,
    ];

    $form['development']['encode_image'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Encode image'),
      '#description' => $this->t('Encode image to base64 before sending to the alt text service. Enable for local development.'),
      '#default_value' => $config->get('encode_image'),
    ];

    $form['development']['autogenerate_use_queue'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Autogenerate use queue'),
      '#description' => $this->t('Autogenerate alt text using queue. Enable for local development.'),
      '#default_value' => $config->get('autogenerate_use_queue'),
    ];

    $form['authorization'] = [
      '#type' => 'details',
      '#title' => $this->t('Authorization'),
      '#open' => FALSE,
    ];

    $form['authorization']['authorization_key'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Authorization Key'),
      '#default_value' => $config->get('authorization_key'),
      '#description' => $this->t('Authorization for the alt text service.'),
      '#required' => FALSE,
    ];

    $form['authorization']['authorization_value'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Authorization Value'),
      '#default_value' => $config->get('authorization_value'),
      '#description' => $this->t('Authorization for the alt text service.'),
      '#required' => FALSE,
    ];

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $this->config('alttexting.settings')
      ->set('api_key', $form_state->getValue('api_key'))
      ->set('autogenerate_on_save', $form_state->getValue('autogenerate_on_save'))
      ->set('autogenerate_use_queue', $form_state->getValue('autogenerate_use_queue'))
      ->set('authorization_key', $form_state->getValue('authorization_key'))
      ->set('authorization_value', $form_state->getValue('authorization_value'))
      ->set('encode_image', $form_state->getValue('encode_image'))
      ->save();

    parent::submitForm($form, $form_state);
  }

}
