<?php

declare(strict_types=1);

namespace Drupal\analytic;

use Drupal\Component\Plugin\PluginInspectionInterface;
use Drupal\Core\Plugin\ContainerFactoryPluginInterface;

/**
 * Analytic interface.
 */
interface AnalyticInterface extends PluginInspectionInterface, ContainerFactoryPluginInterface {

  /**
   * Calculate the daily value.
   */
  public function daily();

  /**
   * Calculate the weekly value.
   */
  public function weekly();

  /**
   * Calculate the monthly value.
   */
  public function monthly();

  /**
   * Calculate the yearly value.
   */
  public function yearly();

}
