<?php

declare(strict_types=1);

namespace Drupal\analytic;

use Drupal\Core\Cache\CacheBackendInterface;
use Drupal\Core\Extension\ModuleHandlerInterface;
use Drupal\Core\Plugin\DefaultPluginManager;

/**
 * Manages search Consumer plugins.
 *
 * @see \Drupal\authorization\Annotation\AuthorizationConsumer
 * @see \Drupal\authorization\Consumer\ConsumerInterface
 * @see \Drupal\authorization\Consumer\ConsumerPluginBase
 * @see plugin_api
 */
class AnalyticPluginManager extends DefaultPluginManager {

  /**
   * Analytic Plugin Manager.
   *
   * @param \Traversable $namespaces
   *   An object that implements \Traversable which contains the root paths
   *   keyed by the corresponding namespace to look for plugin implementations.
   * @param \Drupal\Core\Cache\CacheBackendInterface $cache
   *   The cache Consumer instance to use.
   * @param \Drupal\Core\Extension\ModuleHandlerInterface $module_handler
   *   The module handler.
   */
  public function __construct(
    \Traversable $namespaces,
    CacheBackendInterface $cache,
    ModuleHandlerInterface $module_handler,
  ) {
    parent::__construct(
      'Plugin/Analytic',
      $namespaces,
      $module_handler,
      'Drupal\analytic\AnalyticInterface',
      'Drupal\analytic\Annotation\Analytic'
    );
    $this->setCacheBackend($cache, 'analytic');
    $this->alterInfo('analytic_info');
  }

}
