<?php

declare(strict_types=1);

namespace Drupal\analytic\Attribute;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\Component\Plugin\Attribute\Plugin;

/**
 * Defines an Analytic plugin attribute object.
 *
 * Plugin Namespace: Plugin\Analytic.
 *
 * @see \Drupal\analytic\Plugin\Analytic\AnalyticInterface
 * @see \Drupal\analytic\Plugin\Analytic\AnalyticBase
 * @see \Drupal\analytic\Plugin\Analytic\AnalyticPluginManager
 * @see plugin_api
 */
#[\Attribute(\Attribute::TARGET_CLASS)]
class Analytic extends Plugin {

  /**
   * Constructs an Analytic attribute.
   *
   * @param string $id
   *   The plugin ID.
   * @param \Drupal\Core\StringTranslation\TranslatableMarkup|string $label
   *   The label of the analytic plugin.
   * @param \Drupal\Core\StringTranslation\TranslatableMarkup|string|null $description
   *   A description of the analytic plugin.
   * @param array $dependencies
   *   Dependencies for this analytic plugin. Other Analytic plugins that must
   *   execute first.
   * @param string|null $category
   *   The category this plugin should be grouped under.
   * @param int $weight
   *   The weight of the plugin for sorting purposes.
   */
  public function __construct(
    public readonly string $id,
    public readonly string|TranslatableMarkup $label,
    public readonly string|TranslatableMarkup|null $description = NULL,
    public ?array $dependencies = [],
    public readonly ?string $category = NULL,
    public readonly int $weight = 0,
  ) {}

}
