# AI Brand Voice Analysis

AI-powered brand voice consistency analysis measuring content alignment against your brand guidelines.

## Features

- **Brand Voice Analysis**: AI evaluation against customizable brand guidelines
- **Visual Feedback**: Gauge displays with alignment scores (-1.0 to +1.0)
- **Analyze Framework Integration**: Consistent reporting across analysis tools
- **Batch Processing**: Analyze large content volumes efficiently
- **Custom Guidelines**: Hook-based customization for organization-specific requirements

## Requirements

- [Analyze](https://www.drupal.org/project/analyze) framework
- [AI](https://www.drupal.org/project/ai) module with configured provider

Optional:
- [CKEditor AI Agent](https://www.drupal.org/project/ckeditor_ai_agent) - Provides default brand voice settings

## Installation

```bash
composer require drupal/analyze_ai_brand_voice
drush en analyze_ai_brand_voice
```

## Configuration

### Basic Setup
1. Configure AI provider at `/admin/config/ai/providers`
2. Set brand voice guidelines at `/admin/config/analyze/brand-voice`
3. Enable per content type at `/admin/config/content/analyze-settings`
4. Configure permissions at `/admin/people/permissions#module-analyze_ai_brand_voice`

### Brand Voice Guidelines
Configure at `/admin/config/analyze/brand-voice`:
- Custom brand voice guidelines text
- Tone and style preferences
- Organization-specific writing standards

Default guidelines include:
- Friendly but professional
- Clear and concise
- Empowering and solution-focused
- Knowledgeable without condescension
- Inclusive and welcoming

### Advanced Customization
Use `hook_ai_brand_voice_alter()` for programmatic customization:

```php
function mymodule_ai_brand_voice_alter(string &$brand_voice) {
  $brand_voice = 'Friendly, conversational, expert, inclusive';
}
```

### Batch Processing
1. Go to `/admin/config/analyze/brand-voice/batch`
2. Select content types and processing options
3. Set limits and start batch job
4. Monitor progress and server resources

## Analysis

Results show brand voice alignment scores with visual gauge progression. Cache invalidation is automatic - only re-analyzes when content or configuration changes.

### Display Options
- Gauge visualization with clear progression
- Historical tracking of alignment over time
- Views integration for custom reports
- Color-coded results with Views Color Scales module

## Development

### Docker Commands
```bash
# Lint code
docker compose run --rm drupal-lint

# Check deprecations
docker compose run --rm drupal-check

# Auto-fix issues
docker compose run --rm drupal-lint-auto-fix
```

### Pre-commit Hook
Automatically runs linting checks before commits:
- Auto-fixes coding standard violations
- Blocks commits with remaining issues
- Provides colored output for feedback

