<?php

namespace Drupal\anonymous_token\Access;

use Drupal\Core\Access\CsrfAccessCheck;

/**
 * Class AnonymousCsrfAccessCheck.
 *
 * Provides CSRF access checking for anonymous users.
 *
 * @package Drupal\anonymous_token\Access
 */
class AnonymousCsrfAccessCheck extends CsrfAccessCheck {

  /**
   * Constructs a AnonymousCsrfAccessCheck object.
   *
   * @param \Drupal\anonymous_token\Access\AnonymousCsrfTokenGenerator $csrf_token
   *   The CSRF token generator for anonymous users.
   */
  public function __construct(AnonymousCsrfTokenGenerator $csrf_token) {
    // We can't pass it to the parent constructor as it expects a specific class
    // so we set the inherited property directly.
    $this->csrfToken = $csrf_token;
  }

}
