<?php

declare(strict_types=1);

namespace Drupal\api_connection\Attribute;

use Drupal\Component\Plugin\Attribute\Plugin;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * Defines a RestApiConnection attribute.
 */
#[\Attribute(\Attribute::TARGET_CLASS)]
class RestApiConnection extends Plugin {

  /**
   * Constructs a RestApiConnection attribute.
   *
   * @param string $id
   *   The plugin ID.
   * @param \Drupal\Core\StringTranslation\TranslatableMarkup $label
   *   The connection label.
   * @param bool $activated
   *   Whether the connection is activated or not.
   * @param array $urls
   *   The web service URLs, per environment.
   *    Default array keys are "dev", "test", "live".
   *    See ApiConnectionEnvironment service.
   */
  public function __construct(
    public readonly string $id,
    public readonly TranslatableMarkup $label,
    public readonly bool $activated = TRUE,
    public readonly array $urls = [],
  ) {}

}
